import os
from PIL import Image
import numpy as np

HEX_COLOR = '#618AA6'       # 你要应用的颜色
OUTPUT_PREFIX = 'zb_'  # 输出文件名前缀
FOLDER_PATH = '/Users/mic/Documents/Landmark icons/Monocolor icons/'  # 图片所在文件夹路径

def mix_with_white(rgba_color, alpha):
    # 从 RGBA 中提取颜色和透明度
    r1, g1, b1, a1 = rgba_color
    # 计算混合后的颜色
    r = int((r1 * a1 + 255 * (255 - a1)) / 255)
    g = int((g1 * a1 + 255 * (255 - a1)) / 255)
    b = int((b1 * a1 + 255 * (255 - a1)) / 255)
    return (r, g, b)

def convert_to_colored(image_path, HEX_COLOR, output_path):
    # 打开黑白图片
    try:
        # 打开黑白图片
        img = Image.open(image_path).convert('L')  # 转为灰度模式
    except Exception as e:
        print(f"Error opening image {image_path}: {e}")
        return

    # 获取灰度图像的像素数据
    gray_pixels = np.array(img)

    # 将 hex 颜色转换为 RGB
    color = Image.new('RGB', (1, 1), HEX_COLOR).getpixel((0, 0))

    # 创建一个空白白色背景的图像
    colored_img = Image.new('RGBA', img.size, (255, 255, 255, 255))

    # 获取图像像素
    colored_pixels = colored_img.load()

    # 遍历每个像素，将灰度值作为 alpha 通道，并应用颜色
    for i in range(colored_img.width):
        for j in range(colored_img.height):
            alpha = gray_pixels[j, i]
            colored_pixels[i, j] = (color[0], color[1], color[2], alpha)  # 将混合颜色与原始 alpha 设置为最终像素
            colored_pixels[i, j]= mix_with_white(colored_pixels[i, j], alpha)


    # 保存图像
    colored_img.save(output_path)

def process_images_in_folder(FOLDER_PATH, HEX_COLOR):
    # 获取文件夹中的所有图片文件
    files = os.listdir(FOLDER_PATH)
    print(f"Files in folder: {files}")  # 输出文件夹中的所有文件
    for filename in os.listdir(FOLDER_PATH):
        if filename.endswith(".png"):
            image_path = os.path.join(FOLDER_PATH, filename)
            output_path = os.path.join(FOLDER_PATH, f"{OUTPUT_PREFIX}{filename}")
            print(f"Processing {filename}...")
            convert_to_colored(image_path, HEX_COLOR, output_path)
            print(f"Saved colored image as {output_path}")

# 示例：处理文件夹中的所有图片
process_images_in_folder(FOLDER_PATH, HEX_COLOR)
